<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-19
 * 版本：V1.0
 ****************************************/

require('./include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 Admin_Welcome.asp 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

function countDirSize( $dir )
{
	$sizeResult = 0;
	$handle = opendir( $dir );
	while ( false !== ( $FolderOrFile = readdir( $handle ) ) ) {
		if( $FolderOrFile != "." && $FolderOrFile != ".." ) {
			if( is_dir( "$dir/$FolderOrFile" ) ) {
				$sizeResult += countDirSize("$dir/$FolderOrFile");
			} else {
				$sizeResult += filesize("$dir/$FolderOrFile");
			}
		} 
	}
	closedir($handle);
	return $sizeResult;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "Include/Style.css" />
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">我的状态</div>
		<div class = "Admin_Content">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td><div align="left" style="width:400px;padding:5px;clear:both;font-size:12px"><b>用户名:</b>  <?php echo $_CACHE['user']['user_name'] ?></div></td>
					<td><div align="left" style="width:400px;padding:5px;clear:both;font-size:12px"><b>用户权限:</b>  <?php echo $_SESSION['user_group'] ?></div></td>
				</tr>
			</table>
		</div>
	</div>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">系统信息</div>
		<div class = "Admin_Content">
			<div style="padding:10px;">
				<div id = "Update" style="padding:2px;text-align:left;"></div>
			</div>
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td>
					 	<div align="left" style="width:400px;padding:5px;clear:both;font-size:12px">
							程序版本: XKLog V<?php show_version() ?> <br/>
							<br/>博客名称: <a href = "<?php show_blog_path() ?>" target="_blank"><?php echo $_CACHE['set'][0]['BlogName'] ?></a> <br/>
							<br/>日志数量: <?php echo $_CACHE['count'][0]['article_num'] ?> 篇<br/>
							<br/>评论数量: <?php echo $_CACHE['count'][0]['comment_num'] ?> 条<br/>
							<br/>留言数量: <?php echo $_CACHE['count'][0]['guestbook_num'] ?> 条<br/>
							<br/>会员总数: <?php echo $_CACHE['count'][0]['user_num'] ?> 人<br/>
							<br/>访问次数: <?php echo $_CACHE['set'][0]['VisitNum'] ?> 次<br/>
						</div>
					</td>
					<td>
						<div align="left" style="width:400px;padding:5px;clear:both;font-size:12px">
							待审核评论：<?php echo $db->result( "select count(CID) from " . PREFIX_STR . "Comment where IsShow=False and IsDel=False and ArticleID<>0" ) ?> 条<br/>
							<br/>待审核留言：<?php echo $db->result( "select count(CID) from " . PREFIX_STR . "Comment where IsShow=False and IsDel=False and ArticleID=0" ) ?> 条<br/>
							<br/>物理路径: <?php echo XKLOG_ROOT ?> <br/>
							<br/>解译引擎: <?php echo $_SERVER['SERVER_SOFTWARE'] ?> <br/>
							<br/>PHP版本: <?php echo PHP_VERSION ?> <br/>
							<br/>空间占用: <?php echo round( countDirSize( '../' )/(1024*1024), 2 ) . ' MB' ?> <br/>
							<br/>脚本超时: <?php echo get_cfg_var('max_execution_time') ?> 秒<br/>
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">官方信息</div>
		<div class = "Admin_Content">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td><div align="left" style="width:400px;padding:5px;clear:both;font-size:12px"><b>官方网站: </b><a href = "http://www.xklab.cn" target="_blank">星空工作室</a></div></td>
					<td><div align="left" style="width:400px;padding:5px;clear:both;font-size:12px"><div id = "Announcement">正在加载……</div></div></td>
				</tr>
			</table>
		</div>
	</div>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">开发团队</div>
		<div class = "Admin_Content">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td>
						<div align="left" style="width:400px;padding:5px;clear:both;font-size:12px">
							<b>代码开发:</b> 星空泪<br/>
							<br/><b>风格设计:</b> 星空泪<br/>
						</div>
					</td>
					<td>
						<div align="left" style="width:400px;padding:5px;clear:both;font-size:12px">
							<b>感谢</b>：<br/>
							在后台风格设计中参考了 PJBlog 的部分代码，特此感谢。<br/>
							缓存系统与数据备份参考了 JBlog 的部分代码，特此感谢。
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>

	<div id="Foot"><?php show_run_info()?></div>
</center>
</div>
<script src="http://www.xklab.cn/Announcement.js"></script>
<script> var CVersion = "<?php show_version() ?>" </script>
<script src="http://www.xklab.cn/update.php"></script>
</body>
</html>